

import Alkindi.Data.*;
import Alkindi.Services.*;
import Alkindi.Services.BeanIface.*;
import java.util.*;

public class CMTest
{
	IClusterManagerBean cm = null;

	static CMTest This;
	
	public CMTest() throws AlkExcept
	{
		try {
			cm = BeanUtil.getClusterMgr();
			System.out.println("Created Cluster Manager.");
		}
		catch (Exception e)  {
			throw new AlkExcept(e.toString(), 8000);
		}
	}
	protected void finalize()
	{
		try {
			cm.remove();
		}
		catch(Exception e) {
		}
	}

	// intializeClusters
	//
	void init() throws AlkExcept
	{
		System.out.println("Starting intializeClusters() at " + Calendar.getInstance().getTime());
		/*for (int idx = 1; idx < 9; idx ++) {	
			System.out.println("Intitializing product cluster " + idx);
			cm.initializeClusters(idx);
		}*/
		try {
			cm.initializeClusters();
		}
		catch (AlkExcept ae) {
			throw ae;
		}
		catch (Exception e) {
			throw new AlkExcept(e.toString(), 8000);
		}
		System.out.println("Finished at " + Calendar.getInstance().getTime());

	}

	// regenerateClusters
	//
	void regen() throws AlkExcept
	{
		System.out.println("Starting regenerateClusters() at " + Calendar.getInstance().getTime());
/*		for (int idx = 1; idx < 9; idx ++) {
			System.out.println("Regenerating product cluster " + idx);
			cm.regenClusters(idx);
		}*/
		try {
			cm.regenerateClusters();
		}
		catch (AlkExcept ae) {
			throw ae;
		}
		catch (Exception e) {
			throw new AlkExcept(e.toString(), 8000);
		}
		System.out.println("Finished at " + Calendar.getInstance().getTime());
	}

	void stats() throws AlkExcept
	{
		// recalcStats
		//
		System.out.println("Starting recalcStats() at " + Calendar.getInstance().getTime());
		try {
			cm.recalcStats();
		}
		catch (AlkExcept ae) {
			throw ae;
		}
		catch (Exception e) {
			throw new AlkExcept(e.toString(), 8000);
		}
			System.out.println("Finished at " + Calendar.getInstance().getTime());
	}
	
	void clusterUser(int uid) throws AlkExcept
	{
		System.out.println("Clustering user " + uid);
		SystemUser user = new SystemUser(uid);
		try {
			cm.clusterUser(user);	
		}
		catch (AlkExcept ae) {
			throw ae;
		}
		catch (Exception e) {
			throw new AlkExcept(e.toString(), 8000);
		}
	
	}

	static void usage() 
	{
		System.out.println("Usage: call with a one of the following:");
		System.out.println("\tinit   	- intialize clusters");
		System.out.println("\tregen  	- regenerate clusters");
		System.out.println("\tstats  	- recalc cluster stats");
		System.out.println("\tuser [uid]- cluster the specified user");
		System.exit(1);
	}
	static void main(String[] args) 
	{
		try {
			This = new CMTest();
			if (args.length == 0) {
//			if (args[0].length() == 0) {
				usage();
			}
			else if (args[0].compareTo("init") == 0) {
				This.init();
			}
			else if (args[0].compareTo("regen") == 0 ) {
				This.regen();
			}
			else if (args[0].compareTo("stats") == 0) {
				This.stats();
			}
			else if (args[0].compareTo("user") == 0) {
				if (args.length < 2) {
					usage();
				}
				int uid = Integer.parseInt(args[1]);
				This.clusterUser(uid);
			}

			else {
				usage();
			}
		}
		catch (Exception e) {
			System.out.println("Caught exception: " + e.toString());
			e.printStackTrace();

		}
		
		
	}



}

